//**************************************************************************
/*
 *
 * Copyright (C) 2015 CADCAM-Services Franz Reiter (franz.reiter@cadcam.co.at)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
-----------------------------------------------------
TODO:
// TODO: SUR_pln_ini__ get bPln = backplane of surface of OB-pts via UT3D_bp_pta
  ..

-----------------------------------------------------
Modifications:
2017-12-01 new, rewritten ../gr/tess_su.c (tess. with GLU). RF.

-----------------------------------------------------
*/
#ifdef globTag
void SUR_pln(){}
#endif
/*!
\file  ../xa/tst_ut_surpln.c
\brief Surface planar functions (tesselate, ..)
\code
=====================================================
List_functions_start:


List_functions_end:
=====================================================



=====================================================
*/


#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../ut/ut_geo.h"              // Point ...
#include "../ut/ut_memTab.h"           // MemTab_..
#include "../ut/ut_itmsh.h"            // MSHIG_EDGLN_.. typedef_MemTab.. Fac3

#include "../ut/msh2d.h"               // MSH2D TessStru
#include "../ut/ut_sur.h"              // SurStru



extern union {SUR_DAT_pln pln;
              SUR_DAT_bsp bsp;
             } SUR_DAT__;


  int SUR_pln_tr_2D_3D (Point2 *pt2, Point *pt3);
  int SUR_pln_tr_3D_2D (Point *pt2, Point2 *pt3);



//================================================================
  int SUR_pln_ini_gbx (TessStru *td) {
//================================================================
// set gbx and tolerances.
// see MSH2D_tess_grid


  printf("SUR_pln_ini_gbx \n");

  // set 2D-tolerance;
  // TODO: analog Model-tolerances ? NOT for planar; 1:1 coords
  td->tol = UT_TOL_cv;   // 0.005;


  // define gridbox gbx from (uMin, uMax, vMin, vMax, uNr, vNr)
  // uNr, vNr    nr of faces between Min-Max;
  // planar-surf dos not have support-surface; special.
  MSH2D_tess_pln (&td->gbx);


  return 0;

}


//================================================================
  int SUR_pln_ini__ (SurStru *sd, TessStru *ts) {
//================================================================
// analyze support-surface, set functions tr_2D_3D, tr_3D_2D
// store surface-specific-data in SUR__.td
// see TSU_test_tess_PLN__

  long         l1;
  Vec3f        vcf1;
  Vector       vz;


  printf("SUR_pln_ini__ \n");


  // get SUR_DAT_pln.bPln = backplane for outer-boundary
  SUR_DAT__.pln.bPln = MSH2D_bp_get (&vz, ts);


  //----------------------------------------------------------------
  //  add normalvector into MSH__.vc3
    vcf1.dx = vz.dx;         // UT3F_vc_vc3 ?
    vcf1.dy = vz.dy;
    vcf1.dz = vz.dz;
    MemTab_add (&ts->vc3, &l1, &vcf1, 1, 0);
      MemTab_dump (&ts->vc3, "tessDat.vc3");


  //----------------------------------------------------------------
  // set transform-functions
  sd->tr_2D_3D = SUR_pln_tr_2D_3D;  // transl.func 3D -> 2D
  sd->tr_3D_2D = SUR_pln_tr_3D_2D;  // transl.func 2D -> 3D


  //----------------------------------------------------------------
  // // orient contours (outer-boundary CCW, inner-boundaries CW)
  // // boundaries ts1->bnd
  // ck_orient UT3D_sr_npt_bp
  // irc = SUP_cvcnt_orient__ (&ts1->bnd, ts1->pa3.data, &ts1->vcz);
  // if(irc < 0) return -1;
  


  return 0;

}


//==================================================================
  int SUR_pln_tr_2D_3D (Point2 *pt2, Point *pt3) {
//==================================================================
// TODO use bPln = backplane of surface
// see UT2D_pt_pt3bp

  printf("SUR_pln_tr_2D_3D %lf %lf %lf bP=%d\n",pt3->x, pt3->y,pt3->z,
         SUR_DAT__.pln.bPln);


  switch(SUR_DAT__.pln.bPln) {
    case 2:   // BCKPLN_XY
      pt2->x = pt3->x;
      pt2->y = pt3->y;
      break;

    case 1:   // BCKPLN_XZ
      pt2->x = pt3->x;
      pt2->y = pt3->z;
      break;

    case 0:   // BCKPLN_YZ
      pt2->x = pt3->y;
      pt2->y = pt3->z;
      break;

    default:
      TX_Error("SUR_pln_tr_2D_3D\n");
  }

  return 0;

}


//================================================================
  int SUR_pln_tr_3D_2D (Point *pt3, Point2 *pt2) {
//================================================================

// TODO use bPln = backplane of surface
// see UT3D_pt_pt2bp

  TX_Error("SUR_pln_tr_3D_2D UNUSED !??\n");

/*
  pt2->x = pt3->x;
  pt2->y = pt3->y;


  switch(SUR_DAT__.pln.bPln) {
    case 2:   // BCKPLN_XY
      pt3->x = pt2->x;
      pt3->y = pt2->y;
      pt3->z = 0.;
      break;

    case 1:   // BCKPLN_XZ
      pt3->x = pt2->x;
      pt3->y = 0.;
      pt3->z = pt2->y;
      break;

    case 0:   // BCKPLN_YZ
      pt3->x = 0.;
      pt3->y = pt2->x;
      pt3->z = pt2->y;
      break;

    default:
      TX_Error("SUR_pln_tr_2D_3D\n");
  }
*/

  return 0;

}


// EOF
