#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include <stdarg.h>


// #include "../ut/ut_umem.h"
#include "../ut/ut_cast.h"             // INT_PTR
#include "../ut/ut_geo.h"
#include "../ut/ut_geo_const.h"        // UT3D_CCV_NUL
#include "../ut/ut_ox_base.h"          // OGX_SET_INDEX
#include "../ut/ut_memTab.h"           // MemTab_..
#include "../ut/ut_itmsh.h"            // MSHIG_EDGLN_.. typedef_MemTab.. Fac3
#include "../ut/ut_obj.h"
#include "../ut/ut_bspl.h"             // UT3D_parbsp_par1
#include "../ut/ut_rbspl.h"            // UT3D_par_par1_rbsp
#include "../ut/ut_plg.h"              // UT3D_par1_parplg
#include "../ut/ut_txt.h"              // term_buf
#include "../ut/ut_gtypes.h"           // AP_src_typ__

#include "../ut/func_types.h"          // SYM_TRI_S

#include "../db/ut_DB.h"

#include "../xa/xa_msg.h"                 // MSG_*
#include "../xa/xa_mem.h"                 // memspc54
// #include "../xa/xa_uid.h"               // UI_MODE_MAN




//======================================================================
  int UTO_surfTyp_sur (int *sTyp, long *sDbi, void **sDat, ObjGX *sur) {
//======================================================================
// get form, dbi and dataStruct of supporting surface
// was UTO_ck_surfTyp
// Input:
//   sur      surface; index to ogxTab (support,boundaries)
// Output:
//   sTyp     surfType; Typ_SURPLN|Typ_SURBSP|..
//   sDbi     dbi of support-surface; (not for planar)
//   sDat     data surface; form = sTyp.

  ObjGX  *oxa;


  UTO_dump_s_ (sur, "UTO_surfTyp_sur");
  printf(" form=%d\n",sur->form);


  if(sur->form != Typ_ObjGX) {
    TX_Error("UTO_surfTyp_sur E01-%d",sur->form);
    return -1;
  }

  oxa = sur->data;


  // ObjGX[0])=supporting-surface (CON/TOR/SRU/SRV/SBS/Undef)
  *sTyp = oxa[0].form;
    printf(" sTyp=%d\n",*sTyp);


  // Typ_SURPLN   planar
  if(*sTyp == Typ_modUndef) {
    *sTyp = Typ_SURPLN;
    *sDbi = 0;
    goto L_exit;
  }


  if(*sTyp == Typ_Index) {
    OGX_GET_INDEX (sTyp, sDbi, &oxa[0]);
      printf(" sTyp=%d sDbi=%ld\n",*sTyp,*sDbi);

    // get surface
    oxa = DB_GetSur (*sDbi, 1);
      UTO_dump_s_ (oxa, " -_surfTyp_sur");

    // ObjGX[0])=supporting-surface
    *sDat = oxa->data;
      UT3D_stru_dump (*sTyp, *sDat, " sDat ");

    goto L_exit;
  }



  TX_Error("UTO_surfTyp_sur E02-%d",sTyp);
  return -1; // ERROR !


  L_exit:
      printf("ex-UTO_surfTyp_sur-ssTyp=%d ssDbi=%ld\n",*sTyp,*sDbi);
  return 0;

}


// EOF
