// funcs for ../ut/ut_int.c



#ifdef _MSC_VER
#include "../xa/MS_Def0.h"
#endif

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>                    // for ...


#include "../ut/ut_geo.h"              // Point ...
#include "../ut/ut_memTab.h"           // MemTab_..
#include "../ut/ut_itmsh.h"            // MSHIG_EDGLN_.. typedef_MemTab..

#include "../ut/func_types.h"               // SYM_..
#include "../gr/tess_su.h"             // TypTsuSur
#include "../xa/xa_mem.h"              // memspc51, mem_cbuf1




//=====================================================================
  int INT_nln_nifac_pln (MemTab(Line) *lna, int fNr,
                         Fac3 *fa, int *ipa, Point *pa, Plane *pln) {
//=====================================================================
// INT_nln_nifac_pln         intersect plane - indexed-faces; get lineSegments

  int   irc, i1;
  long  ld;
  Line  ln1;
  Fac3  *fAct;

  printf("INT_nln_nfac_pln %d\n",fNr);


  // loop tru faces
  for(i1=0; i1<fNr; ++i1) {

    // add triangles from patches
    fAct = &fa[i1];

    // intersect
    irc = UT3D_ln_int_tria_pln (&ln1, pln,
                                &pa[ipa[fAct->i1]],
                                &pa[ipa[fAct->i2]],
                                &pa[ipa[fAct->i3]]);
    if(irc < 0) continue;
    if(irc > 1) continue;  // only point in plane ..

      // END TESTBLOCK
      GR_Disp_ln (&ln1, 11);
      // UT3D_stru_dump (Typ_LN, &ln1, "L-%d irc=%d",i1,irc);
      // TESTBLOCK


    // add line to lna
    irc = MemTab_add (lna, &ld, &ln1, 1, 0);
    if(irc > 0) {
      TX_Error("INT_nln_nfac_pln EOM");
      return -1;
    }
  }

    // TESTBLOCK
    printf("ex INT_nln_nifac_pln %d\n",lna->rNr);
    MemTab_dump (lna, "INT_nln_nifac_pln-lna");
    DL_Redraw (); // Redraw DispList
    // END TESTBLOCK


  return 0;

}


//===================================================================
  int INT_nln_nfac_pln (MemTab(Line) *lna,
                        MemTab(Fac3) *ifa, Point *pTab, Plane *pln) {
//===================================================================
// intersect Plane - indexed-triangles --> line-segments
// see also INT_int_tria_pln

  int   i1, irc, lNr;
  long  ld;
  Line  ln1;
  Fac3  *fAct;


  printf("INT_nln_nfac_pln %d\n",ifa->rNr);


  // loop tru faces
  for(i1=0; i1<ifa->rNr; ++i1) {

    // add triangles from patches
    fAct = MEMTAB__ (ifa, i1);
      // printf(" glTyp=%d inr=%d\n",patAct->aux,patAct->iNr);

    // intersect
    irc = UT3D_ln_int_tria_pln (&ln1, pln,
                                &pTab[fAct->i1],
                                &pTab[fAct->i2],
                                &pTab[fAct->i3]);
    if(irc < 0) continue;
    if(irc > 1) continue;  // only point in plane ..

      // END TESTBLOCK
      GR_Disp_ln (&ln1, 11);
      // UT3D_stru_dump (Typ_LN, &ln1, "L-%d irc=%d",i1,irc);
      // TESTBLOCK


    // add line to lna
    irc = MemTab_add (lna, &ld, &ln1, 1, 0);
    if(irc > 0) {
      TX_Error("INT_nln_nfac_pln EOM");
      return -1;
    }
  }

    // TESTBLOCK
    printf("ex INT_nln_nfac_pln %d\n",lna->rNr);
    MemTab_dump (lna, "INT_nln_nfac_pln-lna");
    // END TESTBLOCK

  return 0;

}


// EOF
