/* tst_tess
tesselation with outer-boundary, holes and a rectangular grid.

*/


#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../ut/ut_geo.h"              // Point ...
#include "../ut/ut_geo_const.h"        // UT3D_CCV_NUL
#include "../ut/ut_memTab.h"           // MemTab_..
#include "../ut/ut_itmsh.h"            // MSHIG_EDGLN_.. typedef_MemTab.. Fac3
#include "../ut/ut_face.h"              // UFA

#include "../db/ut_DB.h"               // DB_get_..

#include "../xa/xa_mem.h"              // memspc51, mem_cbuf1
#include "../xa/xa_ato.h"              // ATO_getSpc_tmp__


// Externals aus ../xa/xa.c:
extern char      AP_mod_fnam[128];
extern Plane     WC_sur_act;            // die aktive Plane
extern int       WC_modact_ind;         // -1=primary Model is active;
                                        // else subModel is being created




//=========================================================
  int gCad_fini () {
//=========================================================

  AP_User_reset ();

  return 0;

}


//=========================================================
  int gCad_main () {
//=========================================================


  Memspc wrkSpcT1;

  TX_Print(">>>>>>>>> gCad_main tst_tess <<<<<<<<<<\n");


// TODO: must be added into GL_Init1 ()
  MSHIG_init_ts ();    // new grid-tesselator 2017-06-27





  UME_init (&wrkSpcT1, memspc201, sizeof(memspc201));

  // tst_tess_pln__ (&wrkSpcT1);   // planar-surface-circ
  tst_tess_sbsp__ (&wrkSpcT1);     // B-Spline-Surface
  // tst_tess_swp_cyl (&wrkSpcT1);   // sweep-surf-cylindric;




  DL_Redraw ();

  gCad_fini ();

  return 0;

}


//================================================================
  int tst_tess_sbsp__ (Memspc *wrkSpcT1) {
//================================================================
// B-Spline-Surface = support-surface  from curves along surface
// automatic created outer-boundary (
// was APT_decode_sbsp
// ex Model  test_sur_cyl_5
// P30=P(447.873692 -825.783636 0)
// P31=P30 Z(300)
// P32=P30 Z(600)
// S30=BSP P(547.913653 -312.679356 0) P(244.976163 -625.714759 0) P(143.996999 -938.750161 0) P(194.486581 -1251.785564 0)
// R(P31)
// S31=BSP P(180.751815 372.80902 0) P(-80.03844 196.927222 0) P(-158.882006 -51.733251 0) P(-55.778882 -379.237288 0)
// R(P32)
// S32=BSP P(202.614713 205.099864 0) P(-21.342957 130.447309 0) P(-65.256225 -40.814436 0) P(48.918273 -251.598123 0)
// RZ
// R23=PERP P30 D(0.2 1 0.25)
// A20=BSP U(S30 S31 S32)
// Output  ox1->data:
//   ObjGX[0] supporting-surface (CON/TOR/SRU/SRV/SBS/Undef)
//   ObjGX[1] outer-boundary (CCV)

  char   s1[]={"BSP U(S30 S31 S32)"};
  long   dbiSur = 20L;
  long   dbiPln = 23L;
    
    
  int    irc, aus_typ[10], ausNr, iatt;
  double aus_tab[10];
  ObjAto ato1;
  ObjGX  ox1;
  Memspc wrkSpcP;
  Memspc wrkSpcT2;

  ATO_getSpc_tmp__ (&ato1, 12);
  ATO_ato_srcLn__ (&ato1, s1);
  UME_init (&wrkSpcP, memspc501, sizeof(memspc501));


  UME_init (&wrkSpcT2, mem_cbuf1, mem_cbuf1_SIZ); // 200000 b
  irc = APT_decode_sbsp_2 (&ox1, ato1.nr, ato1.typ, ato1.val,
                           &wrkSpcP, wrkSpcT1, &wrkSpcT2);
  if(irc < 0) return irc;

  DB_StoreSur (&dbiSur, &ox1);   printf(" dbiSur=%ld\n",dbiSur);
    DB_dump_dbo (Typ_SUR, dbiSur, " bsp-1");
    // UTO_dump_s_ (
    // DB_dump_dbo (Typ_SUR, -1L, " bsp-1");
    // DB_dump_dbo (Typ_CV, -15L, " bsp-1");
    // GL_view_dbo (Typ_SUR, dbiSur, 5);


  // delete meshfile
  MSHIG_clear_sur (WC_modact_ind, dbiSur);

  // tesselate or load from file, display mesh
  return MSHIG_load_sur (dbiSur, wrkSpcT1);

}


//================================================================
  int tst_tess_pln__ (Memspc *wrkSpcT1) {
//================================================================
// planar-surface Circ (test_sur_pln1.gcad):   replacing:
// APT_decode_spl    // Standardflaechen (planar, Conic, Torus
// NEW: store planar-surface as TPS-surface !
    // A20=C20 C21

  // char   s1[]={"C20 C21"};  long dbiPln = 20L;         // Circ
  // char   s1[]={"S20 S21"};   long dbiPln = 21L;        // polygon
  char   s1[]={"S23 C23"};   long dbiPln = 20L;        // CCV


  int    irc, aus_typ[10], ausNr, iatt;
  long   dbiSur;
  double aus_tab[10];
  ObjAto ato1;
  ObjGX  ox1;
  Memspc wrkSpcP;


  ATO_getSpc_tmp__ (&ato1, 12);
  ATO_ato_srcLn__ (&ato1, s1);
  UME_init (&wrkSpcP, memspc501, sizeof(memspc501));
  APT_decode_su_pln (&ox1, ato1.nr, ato1.typ, ato1.val, &wrkSpcP);

  dbiSur = 20L;
  DB_StoreSur (&dbiSur, &ox1);   printf(" dbiSur=%ld\n",dbiSur);


  //================================================================
  // TPS-surface: tesselate, save as binary-surface-file
  // get mesh <- file. If not yet exists:
  //   compute grid-values (range,dx,dy..); create grid-points and vectors.
  //   tesselate; create indexed-faces; add vectors for new points
  //   save mesh -> file.


  // delete meshfile
  MSHIG_clear_sur (WC_modact_ind, dbiSur);

  // tesselate or load from file, display mesh
  irc = MSHIG_load_sur (dbiSur, wrkSpcT1);
  if(irc < 0) return irc;


  iatt = 5;
  MSHIG_view__ (7);  // display MSHIG_ts


  // read binary-suface-file, intersect
  // tst_tess_int (dbiSur, wrkSpcT1, Typ_PLN, dbiPln);


  // test outer-boundary of sur <dbiSur>
  // tst_tess_OB
  // // TSU_test_OB__ (dbiSur);


  return 0;

}


//=====================================================================
  int tst_tess_int (long dbiS, Memspc *wrkSpcT1, int typ2, long dbi2) {
//=====================================================================
// read binary-suface-file, intersect
// was TSU_test_intersect

  int          irc, mSiz;
  Line         *lTab;
  Point        *pTab;
  Plane        *pl1;
  MemTab(Fac3) ifa = _MEMTAB_NUL;
  MemTab(Line) lna = _MEMTAB_NUL;


  printf("tst_tess_int %ld %d %ld \n",dbiS,typ2,dbi2);


  // get plane
  pl1 = DB_get_PLN (dbi2);


  // ifa = get Indexed-faces from indexed-patches (fmt + ipa + pta)
  irc = MSHIG_nfac_ipatch (&ifa, &pTab, wrkSpcT1, dbiS);


  // get space for (ifa->rNr) linesegments in lna
  mSiz = (ifa.rNr + 16) * sizeof(Line);      printf(" imSiz=%d\n",mSiz);
  lTab = (Line*) MEM_alloc_tmp (mSiz);
  MemTab_spc (&lna, lTab, mSiz, sizeof(Line), Typ_LN);


  // lna = intersect Indexed-faces ifa with plane pl1; eg S20=INT A20 R20
  INT_nln_nfac_pln (&lna, &ifa, pTab, pl1);


  MemTab_free (&ifa);


  return 0;

}


// EOF
