// xa_gmvo.c                                      2018-02-14  RF
/*
 *
 * Copyright (C) 2018 CADCAM-Services Franz Reiter (franz.reiter@cadcam.co.at)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
-----------------------------------------------------
TODO:
    ..

-----------------------------------------------------
Modifications:
2018-02-14 neu erstellt. RF.

-----------------------------------------------------
*/
#ifdef globTag
 void GMVO(){}
#endif
/*!
\file  ../xa/xa_gmvo.c
\brief Group-MoVe-Objects
\code
=====================================================
List_functions_start:

GMVO__

List_functions_end:
=====================================================
see also
PED_init
UI_WinTra__       alter modelPositionEditor


KERNELMODE -> TESTMODE:
cp ../xa/xa_gmvo.c ../xa/tst_gmvo.c
in ../xa/tst_gmvo.c  change "int GMVO__" -> "int _GMVO__"


TESTMODE -> KERNELMODE:
cp ../xa/tst_gmvo.c ../xa/xa_gmvo.c
in ../xa/xa_gmvo.c change "int _GMVO__" -> "int GMVO__"


\endcode *//*----------------------------------------



*/

#ifdef _MSC_VER
#include "MS_Def0.h"
#endif


#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>                    // va_list
#include <ctype.h>                     // isdigit


#include "../ut/ut_geo.h"              // Point ...
#include "../ut/ut_txt.h"              // fnam_del
#include "../ut/ut_txfil.h"            // UTF_GetnextLnPos
#include "../ut/ut_txTab.h"            // TxtTab
#include "../ut/ut_memTab.h"           // MemTab
#include "../ut/ut_cast.h"             // INT_PTR
#include "../ut/ut_os.h"               // OS_ ..

#include "../xa/xa_ui.h"               // UI_MODE_CAD APF_TB_CAD,
#include "../xa/xa_msg.h"              // MSG_..
#include "../xa/xa_sele.h"             // Typ_go*


#include "../gui/gui__.h"              // Gtk

#define   TRUE 1
#define   FALSE 0



//================================================================
// EXTERN:
// ex ../xa/xa_ui.c
extern MemObj  UIw_Box_TB;    // toolbarBox


//================================================================
// LOCAL:
static MemObj GMVO_tb=GUI_OBJ_NEW;

static MemObj GMVO_bSav;      // button Save
static MemObj GMVO_bCan;      // button Cancel
static MemObj GMVO_bcPl, GMVO_bnPl, GMVO_bfix, GMVO_efix;

static int    GMVO_stat=0;    // 0=move is not active; 1=active;
                              // 2=Save is active; Cancel is active



//================================================================
// PROTOS:
  MemObj GMVO_win__ (MemObj *parent, void *data);
  int GMVO_CB1 (MemObj *mo, void **data);
  int GMVO_mousemove_CB (int dx, int dy);
  int GMVO_key_CB (int key);
  int GMVO_sel_CB (int src, long dl_ind);
  int GMVO_e_CB (MemObj *mo, void **data);



//================================================================
  int _GMVO__ (int mode) {
//================================================================
// move all objs of group

  int       i1, oNr;
  ObjDB     *oTab;

  printf("GMVO__ %d\n",mode);


  // exit if group empty
  oNr = Grp_get__ (&oTab);
  if(oNr < 1) {
    TX_Print ("****** Group is empty - select groupobjects first ..");
    return 0;
  }
    printf(" oNr=%d\n",oNr);

    // TESTBLOCK
    // list grp
    for(i1=0; i1<oNr; ++i1) UT3D_stru_dump(Typ_ObjDB, &oTab[i1], "%d",i1);
    // END TESTBLOCK


  // init GMVO-window
  GMVO_init ();


  return 0;

}


//================================================================
  int GMVO_init () {
//================================================================


/*
  // exit if GMVO is already active
  // man kann GMVO_mode in einer DLL nicht korrekt abfragen,
  // da es in der Dll eine lokale Kopie gibt.
  if(GMVO_mode >= 0) {
    MSG_pri_0 ("GMVOe1"); // ERROR: GMVO is already active ..");
    return 0;
  }
*/

  // if MAN: copy editor -> memory
  AP_SRC_edi_mem ();

  // lock some application-functions...
  UI_func_stat_set__ (-APF_TB_CAD,
                      -APF_MEN_FIL,
                      -APF_MEN_SM,
                      -APF_MEN_MDF,
                      -APF_MEN_APP,
                      // -APF_WIN_B_E,
                      -APF_HIDE,
                      -APF_VWCADMAN,
                      -APF_BUT_GSE,
                      -APF_PLUGINS,
                      -APF_UNDO,
                      0);


  AP_UserKeyIn_get     (GMVO_key_CB);         // attach keystrokes
  AP_UserSelection_get (GMVO_sel_CB);         // attach grafic selections
  AP_UserMousemove_get (GMVO_mousemove_CB);   // attach mousemovements
  UI_block_group (1);                        // block groupSelections



  // init GMVO-toolbar
  if(GUI_OBJ_IS_VALID(&GMVO_tb)) {
    GUI_set_show (&GMVO_tb, 1);

  } else {
    GMVO_tb = GMVO_win__ (&UIw_Box_TB, NULL);
  }



  return 0;

}


//================================================================
  MemObj GMVO_win__ (MemObj *parent, void *data) {
//================================================================
// create Toolbar
     

  static  MemObj tbc = GUI_OBJ_NEW;

  MemObj  box0, box1, box2;


  printf("GMVO_win__ \n");


  if(GUI_OBJ_IS_VALID(&tbc)) goto L_exit;

  tbc = GUI_toolbox__ (parent);

  box0 = GUI_box_h (&tbc, "");
  GUI_label_htm__ (&box0, "<b> Group-move-objects: </b>", "");


  GUI_spc_h (&box0, 5);
  GUI_button__ (&box0, MSG_const__(MSG_help), GMVO_CB1, (void*)"Help", "");
  GUI_spc_h (&box0, 5);

  box1 = GUI_box_h (&box0, "e,e");
  GUI_sep__ (&box1, 1, 5);


  // buttons constrPlane - normal - fixed
  GMVO_bcPl = GUI_radiobutt__
                (&box1, "constrPlane",           1, GMVO_CB1, (void*)"cPln","");
  GMVO_bnPl = GUI_radiobutt__
                (&box1, "normal",                1, GMVO_CB1, (void*)"nPln","");
  GMVO_bfix = GUI_radiobutt__
                (&box1, "fixed",                 1, GMVO_CB1, (void*)"fixd","");

  GMVO_efix = GUI_entry__
                (&box1, "", "",                     GMVO_e_CB, NULL, "10");



  box2 = GUI_box_h (&box0, "e,e");
  GUI_sep__ (&box2, 1, 5);

  // buttons Save/Cancel
  GMVO_bCan = GUI_radiobutt__
                (&box2, MSG_const__(MSG_cancel), 1, GMVO_CB1, (void*)"Canc","");
  GMVO_bSav = GUI_radiobutt__
                (&box2, MSG_const__(MSG_save),   1, GMVO_CB1, (void*)"Save","");




  //----------------------------------------------------------------
  L_exit:

  // GMVO_mode = 0;

  return tbc;

}


//=====================================================================
  int GMVO_CB1 (MemObj *mo, void **data) {
//=====================================================================

  // int  i1, form;
  // long l1;
  char *cp1, cbuf1[256];

  // cp1 = (char*)data;
  cp1 = GUI_DATA_S1;


  printf("GMVO_CB1 |%s|\n",cp1);
  // printf("GMVO_CB1 |%s| %d %d\n",cp1,GMVO_anr,GMVO_mode);


  // skip startup
  // if(GMVO_anr < 1) return 0;
  // if(GMVO_atyp == NULL) return 0;
  // if(GMVO_mode < 0) return 0;




  //-------------------------------------------------
  if(!strcmp(cp1, "Help")) {
    APP_Help ("GMVO", "");


  //-------------------------------------------------
  } else if(!strcmp(cp1, "Canc")) {
    // if(GMVO_changed > 0) {
      // GMVO_exit ();
    // }
    // GMVO_CB1 (NULL, GUI_SETDAT_ES(TYP_EventPress,"Shutdown")); // Shutdown
    GMVO_CB1 (GUI_ES("Shutdown"));


  //-------------------------------------------------
  } else if(!strcmp(cp1, "Save")) {
    // if(GMVO_changed > 0) {
      // GMVO_exit ();
    // }
    // GMVO_CB1 (NULL, GUI_SETDAT_ES(TYP_EventPress,"Shutdown")); // Shutdown
    GMVO_CB1 (GUI_ES("Shutdown"));


  //-------------------------------------------------
  } else if(!strcmp(cp1, "Shutdown")) {
    // GMVO_points (2, 0);              // remove selectionPoints
    AP_UserKeyIn_reset ();
    AP_UserSelection_reset ();      // reset  select
    AP_UserMousemove_reset ();      // reset user-mouseMovementCallback
    UI_block_group (0);             // unblock groupSelections

    // restore some application-functions...
    GUI_toolbox_del (&GMVO_tb);         // remove Toolbar
    // GUI_set_show (&GMVO_tb, 0);        // remove Toolbar

    UI_func_stat_set__ (APF_TB_CAD,
                      APF_MEN_FIL,
                      APF_MEN_SM,
                      APF_MEN_MDF,
                      APF_MEN_APP,
                      // APF_WIN_B_E,
                      APF_HIDE,
                      APF_VWCADMAN,
                      APF_BUT_GSE,
                      APF_PLUGINS,
                      APF_UNDO,
                      0);
/*
    GMVO_restore3 ();                // restore model
    if(GMVO_fp_dep) {
      fclose (GMVO_fp_dep);
      GMVO_fp_dep = NULL;
    }
    if(actPta) {
      free (actPta);
      free (GMVO_atyp);
      free (GMVO_atab);
      actPta = NULL;
      GMVO_anr = 0;
    }

      // printf(" free depTab\n");
    MemTab_free (&depTab);        // free mem
*/
    DL_hili_off (-1L);           // unhilite ..
    AP_SRC_mem_edi ();            // if MAN: copy Memory -> Editor
    // AP_User_reset ();             // gCad_fini ();
    // GMVO_mode = -1;
    // DL_pick__ (1);                // reset selectionfilter
    sele_set__ (Typ_goGeom);      // enable selection of all types


  //-------------------------------------------------
  }

  L_exit:
    return 0;
}


//================================================================
  int GMVO_e_CB (MemObj *mo, void **data) {
//================================================================
// check PED_w_off; if first char == 'D' open PED_w_len.

  int    irc;
  char   *cp1;

  cp1 = GUI_entry_get (&GMVO_efix);

  printf("GMVO_e_CB |%s|\n",cp1);


  return FALSE;  // do defaultOperations

}


//================================================================
  int GMVO_key_CB (int key) {
//================================================================
  
  printf("GMVO_key_CB %d %d\n",key,GMVO_stat);
  // printf("  GMVO_stat=%d GMVO_mode=%d actInd=%d\n",GMVO_stat,GMVO_mode,actInd);
  

  switch (key) {

    case GUI_KeyEsc:
    case 'q':
    case 's':
        // DL_DumpObjTab ();
      // printf(" Esc: md=%d stat=%d\n",GMVO_mode,GMVO_stat);
    
      if(GMVO_stat == 0) {         // Save|Cancel is active
        // GMVO_CB1 (NULL, GUI_SETDAT_ES(TYP_EventPress,"Exit"));
        GMVO_CB1 (GUI_ES("Exit"));
      }
  
/*
      if(GMVO_stat == 1) {         // 1=move is active
        if(GMVO_mode == 0) {       // 0=modify
          GMVO_upd_stop ();        // stop modify-update
        }
      }
*/
      // GMVO_msg__ ();

      return TRUE;  // do no defaultOperations


    default:
      break;
  }

    // printf(" exit GMVO_key_CB\n");

  return FALSE;  // do defaultOperations

}


//=========================================================
  int GMVO_sel_CB (int src, long dl_ind) {
//=========================================================
// userselection callback

  int    irc, styp, typ;
  long   dbi;
  char   *cp1;
  Point  pt1;



  printf("GMVO_sel_CB src=%d ind=%ld\n",src,dl_ind);
  printf("  GMVO_stat=%d\n",GMVO_stat);
  // printf("  GMVO_mode=%d, GMVO_stat=%d\n",GMVO_mode,GMVO_stat);
  // printf("  actTyp=%d actDbi=%ld actInd=%d\n",actTyp,actDbi,actInd);
  // printf("  GMVO_changed=%d\n",GMVO_changed);
  // printf("  GMVO_offTyp=%d\n",GMVO_offTyp);


  // if(iAct) return 0;
  // iAct = 1;



  // obj with wrong type selected ..
  // GMVO_msg__ ();


  return 0;

}

        
//=========================================================
  int GMVO_mousemove_CB (int dx, int dy) {
//=========================================================
// callback mousemovement
// modifys the active point (actPta[actInd])

  // int       mode;
  long      dli;
  Point     pt2;
      

  // printf("------------------------------------------ \n");
  printf("GMVO_mousemove_CB %d %d\n",dx,dy);


  return 0;

}


// EOF
