




#include <math.h>
#include <gtk/gtk.h>
//#include "demo-common.h"

/* In points */
#define HEADER_HEIGHT (10*72/25.4)
#define HEADER_GAP (3*72/25.4)


static GtkWidget *do_widget;

typedef struct
{
  gchar *filename;
  gdouble font_size;

  gint lines_per_page;
  gchar **lines;
  gint num_lines;
  gint num_pages;
} PrintData;



//================================================================
  void GUI_print_beg (GtkPrintOperation *operation,
	                    GtkPrintContext   *context,
	                    gpointer          user_data) {
//================================================================
  PrintData *data = (PrintData *)user_data;
  char *contents;
  int i;
  double height;


  printf("GUI_print_beg \n");

  height = gtk_print_context_get_height (context) - HEADER_HEIGHT - HEADER_GAP;
    printf(" height=%lf\n",height);
    printf(" font_size=%lf\n",data->font_size);
  // data->lines_per_page = floor (height / data->font_size);

/*
  g_file_get_contents (data->filename, &contents, NULL, NULL);
  data->lines = g_strsplit (contents, "\n", 0);
  g_free (contents);


  i = 0;
  while (data->lines[i] != NULL)
    i++;

  data->num_lines = i;
  data->num_pages = (data->num_lines - 1) / data->lines_per_page + 1;

  gtk_print_operation_set_n_pages (operation, data->num_pages);
*/
  gtk_print_operation_set_n_pages (operation, 1);

}


//================================================================
  void GUI_print_pri (GtkPrintOperation *operation,
	                    GtkPrintContext   *context,
	                    gint               page_nr,
	                    gpointer           user_data) {
//================================================================

  PrintData *data = (PrintData *)user_data;
  cairo_t *cr;
  PangoLayout *layout;
  gint text_width, text_height;
  gdouble width;
  gint line, i;
  PangoFontDescription *desc;
  gchar *page_str;


  printf("GUI_print_pri \n");

  // cr = gtk_print_context_get_cairo_context (context);
  // width = gtk_print_context_get_width (context);

  // cairo_rectangle (cr, 0, 0, width, HEADER_HEIGHT);

  // cairo_set_source_rgb (cr, 0.8, 0.8, 0.8);
  // cairo_fill_preserve (cr);

  // cairo_set_source_rgb (cr, 0, 0, 0);
  // cairo_set_line_width (cr, 1);
  // cairo_stroke (cr);

  // layout = gtk_print_context_create_pango_layout (context);

  // desc = pango_font_description_from_string ("sans 14");
  // pango_layout_set_font_description (layout, desc);
  // pango_font_description_free (desc);

  // pango_layout_set_text (layout, data->filename, -1);
  // pango_layout_get_pixel_size (layout, &text_width, &text_height);

  // if (text_width > width)
    // {
      // pango_layout_set_width (layout, width);
      // pango_layout_set_ellipsize (layout, PANGO_ELLIPSIZE_START);
      // pango_layout_get_pixel_size (layout, &text_width, &text_height);
    // }

  // cairo_move_to (cr, (width - text_width) / 2,  (HEADER_HEIGHT - text_height) / 2);
  // pango_cairo_show_layout (cr, layout);

  // page_str = g_strdup_printf ("%d/%d", page_nr + 1, data->num_pages);
  // pango_layout_set_text (layout, page_str, -1);
  // g_free (page_str);

  // pango_layout_set_width (layout, -1);
  // pango_layout_get_pixel_size (layout, &text_width, &text_height);
  // cairo_move_to (cr, width - text_width - 4, (HEADER_HEIGHT - text_height) / 2);
  // pango_cairo_show_layout (cr, layout);

  // g_object_unref (layout);

  // layout = gtk_print_context_create_pango_layout (context);

  // desc = pango_font_description_from_string ("monospace");
  // pango_font_description_set_size (desc, data->font_size * PANGO_SCALE);
  // pango_layout_set_font_description (layout, desc);
  // pango_font_description_free (desc);

  // cairo_move_to (cr, 0, HEADER_HEIGHT + HEADER_GAP);
  // line = page_nr * data->lines_per_page;
  // for (i = 0; i < data->lines_per_page && line < data->num_lines; i++)
    // {
      // pango_layout_set_text (layout, data->lines[line], -1);
      // pango_cairo_show_layout (cr, layout);
      // cairo_rel_move_to (cr, 0, data->font_size);
      // line++;
    // }

  // g_object_unref (layout);

}


//================================================================
  void GUI_print_end (GtkPrintOperation *operation,
                   	       GtkPrintContext   *context,
	                         gpointer          user_data) {
//================================================================

  PrintData *data = (PrintData *)user_data;

  printf("GUI_print_end \n");


  g_free (data->filename);
  g_strfreev (data->lines);
  g_free (data);

}



//================================================================
  int GUI_printer__ (char *fnam) {
//================================================================


  GtkPrintOperation *operation;
  GtkPrintSettings *settings;
  PrintData *data;
  // gchar *uri, *ext;
  // const gchar *dir;
  GError *error = NULL;
  char   s1[256], *ps1;

  GtkPrinter *printer;
  GtkPageSetup *pgSetup;
  GtkPrintBackend *backend;

  printf("GUI_printer__ |%s|\n",fnam); fflush (stdout);

  dialog = gtk_print_unix_dialog_new(NULL, parent);
    if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {

        printer = gtk_print_unix_dialog_get_selected_printer(
GTK_PRINT_UNIX_DIALOG(dialog));

        settings = gtk_print_unix_dialog_get_settings(
GTK_PRINT_UNIX_DIALOG(dialog));

        page_setup = gtk_print_unix_dialog_get_page_setup(
GTK_PRINT_UNIX_DIALOG(dialog));

        print_job = gtk_print_job_new("Example title", printer,
settings, page_setup);

  // s1[0] = '\0';
  // printer = gtk_printer_new (s1, backend, 0); // 0=false
  // ps1 = gtk_printer_get_state_message (GtkPrinter *printer);
  // if (gtk_printer_accepts_ps
  // if (gtk_printer_accepts_pdf
  
  

  // gtk_print_job_new ("Print", printer, settings, pgSetup);
  // gtk_print_job_set_source (&pJob, fnam, &error);
  // gtk_print_job_send (&pJob, CB, udat, dnotif);


  return 0;


  operation = gtk_print_operation_new ();
  data = g_new0 (PrintData, 1);
  data->filename = fnam;
  data->font_size = 12.0;

  g_signal_connect (G_OBJECT (operation), "begin-print",
		    G_CALLBACK (GUI_print_beg), data);
  g_signal_connect (G_OBJECT (operation), "draw-page",
		    G_CALLBACK (GUI_print_pri), data);
  g_signal_connect (G_OBJECT (operation), "end-print",
		    G_CALLBACK (GUI_print_end), data);

  gtk_print_operation_set_use_full_page (operation, FALSE);
  gtk_print_operation_set_unit (operation, GTK_UNIT_POINTS);
  gtk_print_operation_set_embed_page_setup (operation, TRUE);

  settings = gtk_print_settings_new ();
/*
  dir = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
  if (dir == NULL)
    dir = g_get_home_dir ();
  if (g_strcmp0 (gtk_print_settings_get (settings, GTK_PRINT_SETTINGS_OUTPUT_FILE_FORMAT), "ps") == 0)
    ext = ".ps";
  else if (g_strcmp0 (gtk_print_settings_get (settings, GTK_PRINT_SETTINGS_OUTPUT_FILE_FORMAT), "svg") == 0)
    ext = ".svg";
  else
    ext = ".pdf";
*/

  // uri = g_strconcat ("file://", dir, "/", "gtk-demo", ext, NULL);
  sprintf(uri, "file://%s", fnam);


  gtk_print_settings_set (settings, GTK_PRINT_SETTINGS_OUTPUT_URI, uri);

  gtk_print_operation_set_print_settings (operation, settings);

  gtk_print_operation_run (operation,
                           GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG,
                           GTK_WINDOW (do_widget),
                           &error);

  g_object_unref (operation);
  g_object_unref (settings);
  // g_free (uri);

  if (error) {
      GtkWidget *dialog;

      dialog = gtk_message_dialog_new (GTK_WINDOW (do_widget),
				       GTK_DIALOG_DESTROY_WITH_PARENT,
				       GTK_MESSAGE_ERROR,
				       GTK_BUTTONS_CLOSE,
				       "%s", error->message);
      g_error_free (error);

      g_signal_connect (dialog, "response",
			G_CALLBACK (gtk_widget_destroy), NULL);

      gtk_widget_show (dialog);
    }


  return 0;
}

// EOF
